#include <bits/stdc++.h>

using namespace std;

constexpr int BLOCK = 128;

#define CEIL(a, b) ((((a)%(b)) == 0) ? ((a)/(b)) : (((a)/(b))+1))

int main() {
    assert(CEIL(5, 3) == 2);
    assert(CEIL(4, 2) == 2);
    assert(CEIL(0, 3) == 0);

    string s; cin >> s;
    int q; cin >> q;

    vector<int> terms = {0};
    vector<int> blocks,prev;

    int cc = 1;
    for(int i = 1;i<s.size();i++) {
        if(i%BLOCK == 0){
            blocks.emplace_back(cc);
            prev.emplace_back(terms.back());
            cc = (s[i] >= s[i-1]);
        }

        if(s[i] < s[i-1]){
            terms.emplace_back(i);
            cc++;
        }
    }

    blocks.emplace_back(cc);

    vector<int> answers(q);

    for(int i = 0;i<q;i++){
        int l,r; cin >> l >> r; l--, r--;

        auto it = lower_bound(terms.begin(), terms.end(), l);

        if(*it > l)
            it--;

        int c = 0, j = CEIL(l, BLOCK);

        for(;it != terms.end() && *it < min(j*BLOCK, r);it++){
            c++;
        }

        for(;(j+1)*BLOCK-1 <= r;j++){
            c += blocks[j]-(prev[j] != j*BLOCK);
        }

        if(BLOCK*j <= r){
            it = lower_bound(terms.begin(), terms.end(), j*BLOCK);
            for(;it!=terms.end() && *it <= r;it++){
                c++;
            }
        }

        answers[i] = c;
    }

    for(int i = 0;i<q;i++){
        cout << answers[i] << endl;
    }

    return 0;
}